/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.utils.helper.LogHelper;

public class LoginAndPasswordAuthMethod
extends AbstractAuthMethod<AuthPasswordDetails> {
    private final LoginAndPasswordOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public LoginAndPasswordAuthMethod(LoginScene.LoginSceneAccessor accessor) {
        this.accessor = accessor;
        this.application = accessor.getApplication();
        this.overlay = new LoginAndPasswordOverlay(this.application);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthPasswordDetails details) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ContextHelper.runInFxThreadStatic(() -> {
                this.accessor.showContent(this.overlay);
                future.complete(null);
            }).exceptionally(th -> {
                LogHelper.error((Throwable)th);
                return null;
            });
        }
        catch (Exception e) {
            this.accessor.errorHandle(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<AuthFlow.LoginAndPasswordResult> auth(AuthPasswordDetails details) {
        this.overlay.future = new CompletableFuture();
        String login = this.overlay.login.getText();
        if (this.overlay.password.getText().isEmpty() && this.overlay.password.getPromptText().equals(this.application.getTranslation("runtime.scenes.login.password.saved"))) {
            AuthRequest.AuthPasswordInterface password = this.application.runtimeSettings.password;
            return CompletableFuture.completedFuture(new AuthFlow.LoginAndPasswordResult(login, password));
        }
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
        this.overlay.future.complete(this.overlay.getResult());
    }

    @Override
    public void onUserCancel() {
        this.overlay.future.completeExceptionally(LoginAndPasswordOverlay.USER_AUTH_CANCELED_EXCEPTION);
    }

    @Override
    public CompletableFuture<Void> hide() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOverlay() {
        return false;
    }

    public class LoginAndPasswordOverlay
    extends AbstractVisualComponent {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField login;
        private TextField password;
        private CompletableFuture<AuthFlow.LoginAndPasswordResult> future;

        public LoginAndPasswordOverlay(JavaFXApplication application) {
            super("scenes/login/methods/loginpassword.fxml", application);
        }

        @Override
        public String getName() {
            return "loginandpassword";
        }

        public AuthFlow.LoginAndPasswordResult getResult() {
            String rawLogin = this.login.getText();
            String rawPassword = this.password.getText();
            return new AuthFlow.LoginAndPasswordResult(rawLogin, this.application.authService.makePassword(rawPassword));
        }

        @Override
        protected void doInit() {
            this.login = (TextField)LookupHelper.lookup((Node)this.layout, "#login");
            this.password = (TextField)LookupHelper.lookup((Node)this.layout, "#password");
            this.login.textProperty().addListener(l -> LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(this.login.getText().isEmpty() ? LoginAuthButtonComponent.AuthButtonState.UNACTIVE : LoginAuthButtonComponent.AuthButtonState.ACTIVE));
            if (this.application.runtimeSettings.login != null) {
                this.login.setText(this.application.runtimeSettings.login);
                LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(LoginAuthButtonComponent.AuthButtonState.ACTIVE);
            } else {
                LoginAndPasswordAuthMethod.this.accessor.getAuthButton().setState(LoginAuthButtonComponent.AuthButtonState.UNACTIVE);
            }
            if (this.application.runtimeSettings.password != null) {
                this.password.getStyleClass().add((Object)"hasSaved");
                this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password.saved"));
            }
        }

        @Override
        protected void doPostInit() {
        }

        @Override
        public void reset() {
            if (this.password == null) {
                return;
            }
            this.password.getStyleClass().removeAll((Object[])new String[]{"hasSaved"});
            this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password"));
            this.password.setText("");
            this.login.setText("");
        }

        @Override
        public void disable() {
        }

        @Override
        public void enable() {
        }
    }
}

